import java.awt.*;
import java.awt.event.*;
import java.io.*;

import javax.swing.*;

// Referenced classes of package duggelz.jape:
//            BasicStructure, DataChangeListener, ItemPanel, JapeAbout,
//            SaveGame, StatPanel, Actor,
//            Mercenary, DataChangeEvent

public class JapeFrame extends Frame implements DataChangeListener
{

    public JapeFrame()
    {
        super("JAPE - Jagged Alliance 2 Savegame Editor");
        feld = this;
        Color hintergrundfarbe = new Color( (java.awt.SystemColor.menu).getRGB() );
        this.setBackground(hintergrundfarbe);
        try
        {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } catch (Exception e) {
        }
        suche = new String();
        suche = "";
        vergleich = new String();
        vergleich = "";

        layout = new GridBagLayout();
        currentDir = System.getProperty("user.dir");
        createMenuBar();
        Panel body = new Panel();
        body.setLayout(layout);
        add("Center", body);
        actorList = new List();
        actorList.addItemListener(new ItemListener()
        {

            public void itemStateChanged(ItemEvent e)
            {
                doSelectActor();
            }

        });
        GridBagConstraints c1 = new GridBagConstraints();
        c1.fill = 1;
        c1.gridx = 0;
        c1.gridy = 0;
        c1.weighty = 1.0D;
        c1.weightx = 0.0D;
        body.add(actorList, c1);
        statPanel = new StatPanel(this);
        statPanel.addDataChangeListener(this);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 1;
        c2.anchor = 18;
        c2.gridx = 1;
        c2.gridy = 0;
        c2.weighty = 1.0D;
        c2.weightx = 1.0D;
        body.add(statPanel, c2);
        itemPanel = new ItemPanel(this);
        itemPanel.addDataChangeListener(this);
        GridBagConstraints c3 = new GridBagConstraints();
        c3.fill = 1;
        c3.anchor = 18;
        c3.gridx = 2;
        c3.gridy = 0;
        c3.weighty = 1.0D;
        c3.weightx = 1.0D;
        body.add(itemPanel, c3);
        addWindowListener(new WindowAdapter()
        {

            public void windowClosing(WindowEvent e)
            {
                doQuit();
            }

        });
        addNotify();
        populateActorList();
        pack();
        repaint();
    }

    private void createMenuBar()
    {
        menuBar = new MenuBar();
        fileMenu = new Menu("Datei");

        menuBar.add(fileMenu);
        openItem = new MenuItem("Laden..");
        openItem.addActionListener(new ActionListener()
        {

            public void actionPerformed(ActionEvent e)
            {
                doOpen();
            }

        });
        fileMenu.add(openItem);
        openAgainItem = new MenuItem("Erneut ffnen");
        openAgainItem.setEnabled(false);
        openAgainItem.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                if (saveGame.filename != null)
                {
                    OpenGame(saveGame.filename);
                }
            }

        }
        );
        fileMenu.add(openAgainItem);
        saveItem = new MenuItem("Speichern");
        saveItem.addActionListener(new ActionListener()
        {

            public void actionPerformed(ActionEvent e)
            {
                doSave();
            }

        });
        fileMenu.add(saveItem);
        saveItem.setEnabled(false);

        saveasItem = new MenuItem("Speichern unter");
        saveasItem.addActionListener(new ActionListener()
        {

            public void actionPerformed(ActionEvent e)
            {
                doSaveas();
            }

        }
        );
        fileMenu.add(saveasItem);
        saveasItem.setEnabled(false);


        closeItem = new MenuItem("Schlieen");
        closeItem.addActionListener(new ActionListener()
        {

            public void actionPerformed(ActionEvent e)
            {
                doClose();
            }

        });
        fileMenu.add(closeItem);
        closeItem.setEnabled(false);
        fileMenu.addSeparator();
        quitItem = new MenuItem("Beenden");
        quitItem.addActionListener(new ActionListener()
        {

            public void actionPerformed(ActionEvent e)
            {
                doQuit();
            }

        }
        );
        fileMenu.add(quitItem);
        bearbeitenMenu = new Menu("Bearbeiten");
        bearbeitenMenu.setEnabled(false);
        menuBar.add(bearbeitenMenu);
        helpMenu = new Menu("Hilfe");
        nosortItem = new MenuItem("RPC unsortiert");
        bearbeitenMenu.add(nosortItem);
        bearbeitenMenu.addActionListener(new ActionListener()
        {

            public void actionPerformed(ActionEvent e)
            {
                doNoSort();
            }

        });

        sortbyMercItem = new MenuItem("RPC sortiert");
        sortbyMercItem.addActionListener(new ActionListener()
        {

            public void actionPerformed(ActionEvent e)
            {
                doSort();
            }

        }
        );

        bearbeitenMenu.add(sortbyMercItem);
        menuBar.add(helpMenu);
        menuBar.setHelpMenu(helpMenu);
        aboutItem = new MenuItem("ber...");
        helpMenu.add(aboutItem);
        aboutItem.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                String Nachricht =
                "JAPE: A Jagged Alliance 2 Save Game Editor\n" +
                "Version 0.34\n" +
                "Copyright (c) 1999  Douglas Greiman\n" +
                "Deutsche Portierung (c) 2005 von Bernd Leitenberger\n";
                JOptionPane.showMessageDialog(null, Nachricht, "Info ber Jape",
                JOptionPane.INFORMATION_MESSAGE);
            }

        }
        );
        setMenuBar(menuBar);
    }

    public void dataChanged(DataChangeEvent event)
    {
        saveGameModified = true;
    }


    public boolean doClose()
    {
        if (saveGame != null && saveGameModified)
        {
            String shortName = (new File(saveGame.filename)).getName();
            int option = JOptionPane.showConfirmDialog(this,
            "Die Datei " + shortName + " wurde verndert.\n" +
            "Wollen Sie die nderungen speichern ?", getTitle(),
            JOptionPane.YES_NO_CANCEL_OPTION,
            JOptionPane.QUESTION_MESSAGE);
            if (option == JOptionPane.CANCEL_OPTION)
            {
                return false;
            }
            if (option == JOptionPane.YES_OPTION)
            {
                boolean success = doSave();
                if (!success)
                {
                    return false;
                }
            }
        }
        saveItem.setEnabled(false);
        saveasItem.setEnabled(false);
        closeItem.setEnabled(false);
        openAgainItem.setEnabled(false);
        bearbeitenMenu.setEnabled(false);
        saveGame = null;
        saveGameModified = false;
        populateActorList();
        return true;
    }

    private boolean OpenGame(String filename)
    {
        SaveGame saveGame = new SaveGame();
        try
        {
            saveGame.load(filename);
        }
        catch (EOFException _ex)
        {
            JOptionPane.showMessageDialog(this,
            "Kann Datei nicht laden.\nUnerwartet Dateiende erreicht.",
            getTitle(), 0);
            return false;
        }
        catch (FileNotFoundException _ex)
        {
            JOptionPane.showMessageDialog(this,
            "Kann Datei nicht laden.\nDatei kann nicht gefunden oder geladen werden",
            getTitle(), 0);
            return false;
        }
        catch (IOException e)
        {
            String errorMessage = e.getMessage();
            if (e.getMessage() == null)
            {
                errorMessage =
                "Ein nicht genau spezifizierter Fehler trat auf.";
            }
            JOptionPane.showMessageDialog(this,
            "Kann Datei nicht laden.\n" +
            errorMessage,
            getTitle(), 0);
            return false;
        }
        catch (SaveGame.FormatException _ex)
        {
            JOptionPane.showMessageDialog(this,
            "Kann Datei nicht laden.\nDas Spielformat ist unbekannt.",
            getTitle(), 0);
            return false;
        }
        saveItem.setEnabled(true);
        saveasItem.setEnabled(true);
        bearbeitenMenu.setEnabled(true);
        closeItem.setEnabled(true);
        openAgainItem.setEnabled(true);
        this.saveGame = saveGame;
        populateActorList();
        actorList.select(0);
        doSelectActor();
        saveGameModified = false;
        return true;

    }

    public boolean doSaveas()
    {
        String dateiname = saveGame.filename;

        FileDialog fileDialog = new FileDialog(this, "Speichern unter", 0);
        fileDialog.setMode(1);
        if (currentDir != null)
        {
            fileDialog.setDirectory(currentDir);
        }
        fileDialog.setFile(dateiname);
        fileDialog.show();
        String directory = fileDialog.getDirectory();
        dateiname = fileDialog.getFile();
        if (dateiname == null)
        {
            return false;
        }
        currentDir = directory;
        dateiname= (new File(directory, dateiname)).toString();
        if (saveGame == null)
        {
            return true;
        }
        try
        {
            saveGame.saveAs(dateiname);
        }
        catch (IOException e)
        {
            String errorMessage = e.getMessage();
            if (e.getMessage() == null)
            {
                errorMessage =
                "Ein nicht genau spezifizierter Fehler trat auf.";
            }
            JOptionPane.showMessageDialog(this,
            "Kann die Datei nicht speichern.\n" +
            errorMessage, getTitle(), 0);
            return false;
        }
        saveGameModified = false;
        statPanel.setModified(false);
        itemPanel.setModified(false);
        return true;
    }

    public boolean doSort()
    {
        actorList.removeAll();
        doSetActor(null, null);
        if (saveGame == null)
        {
            return false;
        }
        String[] liste = new String[saveGame.actorCount];
        for (int idx = 0; idx < saveGame.actorCount; idx++)
        {
            Actor actor = saveGame.getActor(idx);
            String nickname = actor.get("Nickname");
            Mercenary merc = saveGame.getMercByNick(nickname);
            if (merc != null)
            {
                nickname = "*" + nickname;
            }
            liste[idx] = new String(nickname);
        }
        String temp = new String();
        for (int i = 0; i < liste.length - 1; i++)
        {
            for (int j = i + 1; j < liste.length; j++)
            {
                if (liste[i].compareToIgnoreCase(liste[j]) > 0)
                {
                    temp = liste[i];
                    liste[i] = liste[j];
                    liste[j] = temp;
                }
            }
        }
        for (int i = 0; i < liste.length; i++)
        {
            if (liste[i].length() > 0)
            {
                actorList.add(liste[i]);
            }
        }
        return true;
    }

    public boolean doNoSort()
    {
        actorList.removeAll();
        doSetActor(null, null);
        if (saveGame == null)
        {
            return false;
        }
        String[] liste = new String[saveGame.actorCount];
        for (int idx = 0; idx < saveGame.actorCount; idx++)
        {
            Actor actor = saveGame.getActor(idx);
            String nickname = actor.get("Nickname");
            Mercenary merc = saveGame.getMercByNick(nickname);
            if (merc != null)
            {
                nickname = "*" + nickname;
            }
            actorList.add(nickname);
        }
        return true;
    }

    public boolean doOpen()
    {
        boolean success = doClose();
        if (!success)
        {
            return false;
        }
        FileDialog fileDialog = new FileDialog(this, "ffnen", 0);
        if (currentDir != null)
        {
            fileDialog.setDirectory(currentDir);
        }
        fileDialog.setFile("*.sav");
        fileDialog.show();
        String directory = fileDialog.getDirectory();
        String name = fileDialog.getFile();
        if (name == null)
        {
            return false;
        }
        currentDir = directory;
        String filename = (new File(directory, name)).toString();
        OpenGame(filename);
        return true;
    }

    public boolean doQuit()
    {
        boolean success = doClose();
        if (!success)
        {
            return false;
        }
        else
        {
            setVisible(false);
            dispose();
            System.exit(0);
            return true;
        }
    }

    public boolean doSave()
    {
        if (saveGame == null)
        {
            return true;
        }
        try
        {
            saveGame.save();
        }
        catch (IOException e)
        {
            String errorMessage = e.getMessage();
            if (e.getMessage() == null)
            {
                errorMessage =
                "Ein nicht genau spezifizierter Fehler trat auf.";
            }
            JOptionPane.showMessageDialog(this,
            "Kann die Datei nicht speichern.\n" +
            errorMessage, getTitle(), 0);
            return false;
        }
        saveGameModified = false;
        statPanel.setModified(false);
        itemPanel.setModified(false);
        return true;
    }

    private boolean doSelectActor()
    {
        int idx = actorList.getSelectedIndex();
        String name = actorList.getItem(idx);
        if (name.length() > 0 && name.startsWith("*"))
        {
            name = name.substring(1, name.length());
        }
        Actor actor = null;
        Mercenary merc = null;
        if (idx != -1)
        {

           /*               actor = saveGame.getActor(idx);
                         String nickname = actor.get("Nickname");
                         merc = saveGame.getMercByNick(nickname);*/
            actor = saveGame.getActorByNick(name);
            String nickname = name;
            merc = saveGame.getMercByNick(nickname);

        }
        doSetActor(actor, merc);
        return true;
    }

    private void doSetActor(Actor actor, Mercenary merc)
    {
        currentActor = actor;
        currentMerc = merc;
        statPanel.setActor(currentActor, currentMerc);
        itemPanel.setActor(currentActor, currentMerc);
    }

    public static void main(String args[])
    {
        JapeFrame japeFrame = new JapeFrame();
        japeFrame.show();
    }

    private void populateActorList()
    {
        actorList.removeAll();
        doSetActor(null, null);
        if (saveGame == null)
        {
            return;
        }
        String[] liste = new String[saveGame.actorCount];
        for (int idx = 0; idx < saveGame.actorCount; idx++)
        {
            Actor actor = saveGame.getActor(idx);
            String nickname = actor.get("Nickname");
            Mercenary merc = saveGame.getMercByNick(nickname);
            if (merc != null)
            {
                nickname = "*" + nickname;
            }
            liste[idx] = new String(nickname);
            // actorList.add(nickname);
        }
        String temp = new String();
        for (int i = 0; i < liste.length - 1; i++)
        {
            for (int j = i + 1; j < liste.length; j++)
            {
                if (liste[i].compareToIgnoreCase(liste[j]) > 0)
                {
                    temp = liste[i];
                    liste[i] = liste[j];
                    liste[j] = temp;
                }
            }
        }
        for (int i = 0; i < liste.length; i++)
        {
            if (liste[i].length() > 0)
            {
                actorList.add(liste[i]);
            }
        }
        actorList.addFocusListener(new FocusListener()
        {
            public void focusGained(FocusEvent e)
            {
                suche = "";
            }

            public void focusLost(FocusEvent e)
            {
                suche = "";
            }
        }
        );

        actorList.addKeyListener(new KeyListener()
        {
            public void keyPressed(KeyEvent event)
            {
                if (event.getKeyCode() == KeyEvent.VK_ESCAPE)
                {
                    suche = "";
                    return;
                }
                ;
                if (event.getKeyCode() == KeyEvent.VK_BACK_SPACE)
                {
                    if (suche.length() > 1)
                    {
                        suche = suche.substring(0, suche.length() - 1);
                    }
                    else
                    {
                        suche = "";
                    }
                    return;
                }
                suche = suche + event.getKeyChar();
                suche = suche.toLowerCase();

                for (int idx = 0; idx < saveGame.actorCount; idx++)
                {
                    vergleich = saveGame.getActor(idx).get("Nickname");
                    if (suche.length() < vergleich.length())
                    {
                        vergleich = vergleich.substring(0, suche.length());
                    }
                    vergleich = vergleich.toLowerCase();
                    if (suche.equals(vergleich))
                    {
                        actorList.select(idx);
                        doSelectActor();
                        return;
                    }
                }
            }

            public void keyTyped(KeyEvent event)
            {
            }

            public void keyReleased(KeyEvent event)
            {
            }

        }
        );
    }

    public static void setcaption(String caption)
    {
        feld.setTitle(caption);
    }

    private static final int DEFAULT_WIDTH = 450;
    private static final int DEFAULT_HEIGHT = 450;
    public static final long serialVersionUID = 030265332;
    private GridBagLayout layout;
    private List actorList;
    private StatPanel statPanel;
    private ItemPanel itemPanel;
    private MenuBar menuBar;
    private Menu fileMenu;
    private Menu bearbeitenMenu;
    private MenuItem openItem;
    private MenuItem saveItem;
    private MenuItem saveasItem;
    private MenuItem closeItem;
    private MenuItem quitItem;
    private MenuItem openAgainItem;
    private MenuItem sortbyMercItem;
    private MenuItem nosortItem;
    private Menu helpMenu;
    private MenuItem aboutItem;
    private SaveGame saveGame;
    private boolean saveGameModified;
    private Actor currentActor;
    private Mercenary currentMerc;
    private String currentDir;
    private static Frame feld;
    private String suche, vergleich;

}
